import 'package:play_lab/data/model/global/telivision/telivision.dart';

class TelevisionListModel {
  List<Television>? data;
  dynamic nextPageUrl;

  TelevisionListModel({
    this.data,
    this.nextPageUrl,
  });

  factory TelevisionListModel.fromJson(Map<String, dynamic> json) => TelevisionListModel(
        data: json["data"] == null ? [] : List<Television>.from(json["data"]!.map((x) => Television.fromJson(x))),
        nextPageUrl: json["next_page_url"],
      );

  Map<String, dynamic> toJson() => {
        "data": data == null ? [] : List<dynamic>.from(data!.map((x) => x.toJson())),
        "next_page_url": nextPageUrl,
      };
}
